<?php
error_reporting(E_ALL^(E_NOTICE|E_WARNING));
ini_set('display_errors',1);
error_reporting(0);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kartu Tagihan - MMU A-39 REJOSARI</title>
    
    <style>
        :root {
            --primary-color: #2563eb;
            --secondary-color: #64748b;
            --success-color: #059669;
            --warning-color: #d97706;
            --danger-color: #dc2626;
            --dark-color: #1e293b;
            --light-color: #f8fafc;
            --border-radius: 12px;
            --box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --box-shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }

        body {
            background: linear-gradient(135deg,rgb(187, 193, 220) 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .main-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow-lg);
            margin: 20px auto;
            max-width: 1200px;
        }

        .page-header {
            background: linear-gradient(135deg, var(--primary-color),rgb(144, 175, 224));
            color: white;
            padding: 1rem;
            border-radius: var(--border-radius) var(--border-radius) 0 0;
            position: relative;
            overflow: hidden;
        }

        .page-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.1;
        }

        .page-header h3 {
            font-size: 1.5rem;
            font-weight: 700;
            margin: 0;
            position: relative;
            z-index: 1;
        }

        .page-header .subtitle {
            font-size: 1.1rem;
            opacity: 0.9;
            margin-top: 0.5rem;
            position: relative;
            z-index: 1;
        }

        .search-card {
            background: white;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            padding: 2rem;
            margin: 2rem;
            border: 1px solid rgba(0, 0, 0, 0.05);
        }

        .form-control {
            border-radius: 8px;
            border: 2px solid #e2e8f0;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }

        .form-control:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        .btn {
            border-radius: 8px;
            padding: 0.75rem 1.5rem;
            font-weight: 600;
            transition: all 0.3s ease;
            border: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), #3b82f6);
            box-shadow: 0 4px 14px 0 rgba(37, 99, 235, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px 0 rgba(37, 99, 235, 0.5);
        }

        .btn-success {
            background: linear-gradient(135deg, var(--success-color), #10b981);
            box-shadow: 0 4px 14px 0 rgba(5, 150, 105, 0.4);
        }

        .btn-success:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px 0 rgba(5, 150, 105, 0.5);
        }

        .info-card {
            background: linear-gradient(135deg, #f8fafc, #ffffff);
            border-radius: var(--border-radius);
            padding: 2rem;
            margin: 2rem;
            box-shadow: var(--box-shadow);
            border-left: 5px solid var(--primary-color);
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.75rem 0;
            border-bottom: 1px solid #e2e8f0;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: 600;
            color: var(--secondary-color);
            min-width: 120px;
        }

        .info-value {
            font-weight: 700;
            color: var(--dark-color);
            flex: 1;
            text-align: left;
            margin-left: 1rem;
        }

        .table-container {
            background: white;
            border-radius: var(--border-radius);
            overflow: hidden;
            box-shadow: var(--box-shadow);
            margin: 2rem;
        }

        .table {
            margin: 0;
        }

        .table thead th {
            background: linear-gradient(135deg, var(--dark-color), #334155);
            color: white;
            border: none;
            padding: 1rem;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.875rem;
            letter-spacing: 0.5px;
        }

        .table tbody td {
            padding: 1rem;
            border-bottom: 1px solid #e2e8f0;
            vertical-align: middle;
        }

        .table tbody tr:hover {
            background-color: #f8fafc;
            transform: scale(1.01);
            transition: all 0.2s ease;
        }

        .table tfoot th {
            background: linear-gradient(135deg, var(--primary-color), #3b82f6);
            color: white;
            padding: 1rem;
            font-weight: 700;
            border: none;
        }

        .currency {
            font-family: 'Courier New', monospace;
            font-weight: 600;
        }

        .no-data-message {
            text-align: center;
            padding: 3rem;
            color: var(--secondary-color);
            font-size: 1.1rem;
        }

        .loading-spinner {
            display: none;
            text-align: center;
            padding: 2rem;
        }

        .spinner-border {
            color: var(--primary-color);
        }

        @media (max-width: 768px) {
            .main-container {
                margin: 10px;
            }
            
            .page-header {
                padding: 1.5rem;
            }
            
            .page-header h1 {
                font-size: 2rem;
            }
            
            .search-card, .info-card, .table-container {
                margin: 1rem;
                padding: 1.5rem;
            }
            
            .table-responsive {
                font-size: 0.875rem;
            }
        }

        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="main-container">
            <!-- Page Header -->
            <div class="page-header">
                <h3><i class="fas fa-credit-card me-3"></i>Kartu Tagihan</h3>
               <!--  <p class="subtitle">MMU A-39 REJOSARI - Sistem Informasi Pembayaran</p> -->
            </div>

            <?php     
            require './kalenderhijriah.php';     
            $kode = $_SESSION['kode'];
            if(isset($_POST['rekening'])){
                $rekening = $_POST['rekening'];
                $tglmasehi = date('Y-m-d', strtotime($_POST['tglmasehi']));
                if($_POST['rekening'] == 'Pilih')
                    $where = "where id='0'";
                else
                    $where = "where id='$rekening'";
            } else {
                $par1 = "";
                $par2 = "";
                $rekening = "";
                $where = "where id='$rekening'";
            }
            ?>

            <!-- Search Form -->
            <div class="search-card fade-in">
                <form role="form" id="quickForm" action="" method="POST">
                    <div class="row g-3 align-items-end">
                        <div class="col-md-3">
                            <label for="rekening" class="form-label">
                                <i class="fas fa-user me-2"></i>Nomor Rekening
                            </label>
                            <input type="text" id="rekening" name="rekening" maxlength="16" 
                                   value="<?php echo isset($_POST['rekening']) ? $_POST['rekening'] : ''; ?>" 
                                   class="form-control" placeholder="Masukkan nomor rekening" autofocus>
                        </div>
                        <div class="col-md-3">
                            <label for="tglmasehi" class="form-label">
                                <i class="fas fa-calendar me-2"></i>Tanggal
                            </label>
                            <input type="date" name="tglmasehi" id="tglmasehi" class="form-control"
                                   value="<?php echo isset($_POST['tglmasehi']) ? $_POST['tglmasehi'] : date('Y-m-d'); ?>">
                        </div>
                        <div class="col-md-3">
                            <button type="submit" name="proses" class="btn btn-primary w-100" value="Cari">
                                <i class="fas fa-search me-2"></i>Cari Data
                            </button>
                        </div>
                        <?php if(isset($_POST['rekening'])): ?>
                        <div class="col-md-3">
                            <a href="pdf/lap_kartu_tagihan_pdf.php" target="_blank" class="btn btn-success w-100">
                                <i class="fas fa-file-pdf me-2"></i>Cetak PDF
                            </a>
                        </div>
                        <?php endif; ?>
                    </div>
                </form>
            </div>

            <?php
            function buatrp($angka){
                $jadi = "Rp " . number_format($angka, 0, ',', '.');
                return $jadi;
            }

            include 'koneksi.php';
            
            $querya = "SELECT tgl as tgl, nama AS nama, alamat AS alamat, rtrw as rtrw from registrasi $where";
            $query = mysqli_query($koneksi, $querya);
            
            $nama = "";
            $alamat = "";
            $rtrw = "";
            $tgl = "";
            $blokir = 0;
            $saldotab = 0;
            
            if(mysqli_num_rows($query)){
                while ($data = mysqli_fetch_assoc($query)) {
                    $tgl = $data['tgl'];
                    $nama = $data['nama'];
                    $alamat = $data['alamat'];
                    $rtrw = $data['rtrw'];
                }
            }
            
            if(isset($_POST['rekening'])){
                $_SESSION['ktagihan']['judul'] = "KARTU TAGIHAN";
                $_SESSION['ktagihan']['unit'] = "MMU A-39 REJOSARI";
                $_SESSION['ktagihan']['rekening'] = $_POST['rekening'];
                
                if($_POST['rekening'] == 'Pilih')
                    $_SESSION['laporan']['rekening'] = 'Pilih';
                else
                    $_SESSION['laporan']['rekening'] = "SELECT * FROM mutasiTAGIHAN where rekening='" . $_POST['rekening'] . "'";
            ?>

            <!-- Customer Information -->
            <div class="info-card fade-in">
                <h5 class="mb-4"><i class="fas fa-user-circle me-2"></i>Informasi Nasabah</h5>
                <div class="info-row">
                    <span class="info-label">Nama Lengkap</span>
                    <span class="info-value"><?php echo $nama; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Nomor Rekening</span>
                    <span class="info-value"><?php echo $_POST['rekening']; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Alamat</span>
                    <span class="info-value"><?php echo $alamat . " " . $rtrw; ?></span>
                </div>
                <div class="info-row">
                    <span class="info-label">Tanggal Laporan</span>
                    <span class="info-value"><?php echo date('d F Y', strtotime($_POST['tglmasehi'])); ?></span>
                </div>
            </div>

            <!-- Transaction Table -->
            <div class="table-container fade-in">
                <div class="table-responsive">
                    <table id="example3" class="table table-hover">
                        <thead>
                            <tr>
                                <th width="5%">No</th>
                                <th width="12%">Tanggal</th>
                                <th width="15%">No Bukti</th>
                                <th width="20%">Tagihan</th>
                                <th width="20%">Pembayaran</th>
                                <th width="28%">Keterangan</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $no = 1;
                            $queryp = "
                            SELECT YEAR(tgl) AS tahun,MONTH(tgl) AS bulan,MONTHNAME(tgl) AS nama_bulan,DATE_FORMAT(tgl, '%Y-%m') AS periode,
    tgl,no_bukti,id,nim,kewajiban,bayar,(kewajiban - bayar) AS sisa,keterangan,source_table
FROM (
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'bulanan' AS source_table
    FROM bulanan 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
    
    UNION ALL
    
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'kitab' AS source_table
    FROM kitab 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
    
    UNION ALL
    
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'seragam' AS source_table
    FROM seragam 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
    
    UNION ALL
    
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'ikhtibar' AS source_table
    FROM ikhtibar 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
    
    UNION ALL
    
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'imni' AS source_table
    FROM imni 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
    
    UNION ALL
    
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'iuran' AS source_table
    FROM iuran 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
    
    UNION ALL
    
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'imda1' AS source_table
    FROM imda1 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
    UNION ALL
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'imda2' AS source_table
    FROM imda2 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
    UNION ALL
    SELECT tglmasehi AS tgl, no_bukti, id, nim, kewajiban, bayar, keterangan, 'imda3' AS source_table
    FROM imda3 
    WHERE id='$rekening' AND tglmasehi<='$tglmasehi'
) AS combined_data
ORDER BY SUBSTR(no_bukti, 1, 2),tahun ASC, bulan ASC, tgl ASC, source_table ASC ";
                            
                            $query = mysqli_query($koneksi, $queryp);
                            $t_kwajiban = 0;
                            $t_bayar = 0;
                            
                            if(mysqli_num_rows($query)){
                                while ($data = mysqli_fetch_assoc($query)) {
                                    $tgl = $data['tgl'];
                                    $no_bukti = $data['no_bukti'];
                                    $keterangan = $data['keterangan'];
                                    $kewajiban = $data['kewajiban'];
                                    $bayar = $data['bayar'];
                                    $t_kwajiban += $kewajiban;
                                    $t_bayar += $bayar;
                                    ?>
                                    <tr>
                                        <td class="text-center"><?php echo $no++; ?></td>
                                        <td class="text-center"><?php echo date('d/m/Y', strtotime($tgl)); ?></td>
                                        <td class="text-center">
                                            <span class="badge bg-primary"><?php echo $no_bukti; ?></span>
                                        </td>
                                        <td class="text-end currency"><?php echo buatrp($kewajiban); ?></td>
                                        <td class="text-end currency"><?php echo buatrp($bayar); ?></td>
                                        <td><?php echo $keterangan; ?></td>
                                    </tr>
                                    <?php
                                }
                            } else {
                                echo '<tr><td colspan="6" class="text-center py-5">Tidak ada data transaksi ditemukan</td></tr>';
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-center">TOTAL</th>
                                <th class="text-end currency"><?php echo buatrp($t_kwajiban); ?></th>
                                <th class="text-end currency"><?php echo buatrp($t_bayar); ?></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <?php
            $_SESSION['ktagihan']['sql1'] = $querya;
            $_SESSION['ktagihan']['sql2'] = $queryp;
            } else {
            ?>
            <div class="no-data-message fade-in">
                <i class="fas fa-search fa-3x mb-3 text-muted"></i>
                <h5>Silakan masukkan nomor rekening untuk melihat kartu tagihan</h5>
                <p class="text-muted">Masukkan nomor rekening dan tanggal untuk menampilkan riwayat transaksi</p>
            </div>
            <?php } ?>
        </div>
    </div>

    <!-- Scripts -->
    <!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script> -->
    
    <script>
$(document).ready(function() {
    // Cek apakah DataTable sudah diinisialisasi sebelumnya
    if ($.fn.DataTable.isDataTable('#example3')) {
        $('#example3').DataTable().destroy();
    }
    
    // Hanya inisialisasi DataTable jika tabel memiliki data
    if ($('#example3 tbody tr').length > 0) {
        $('#example3').DataTable({
            "pageLength": 25,
            "responsive": true,
            "order": [[1, "desc"]],
            "columnDefs": [
                { "orderable": false, "targets": 0 }
            ]
        });
    }

    // Auto-focus on rekening input
    $('#rekening').focus();

    // Form validation
    $('#quickForm').on('submit', function(e) {
        if ($('#rekening').val().trim() === '') {
            e.preventDefault();
            alert('Nomor rekening harus diisi!');
            $('#rekening').focus();
            return false;
        }
    });

    // Add loading animation
    $('#quickForm').on('submit', function() {
        $(this).find('button[type="submit"]').html('<i class="fas fa-spinner fa-spin me-2"></i>Mencari...');
    });
});
</script>
</body>
</html>